% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_tippy.R
\name{use_tippy}
\alias{use_tippy}
\alias{call_tippy}
\title{Use tippy}
\usage{
use_tippy()

call_tippy(target, ...)
}
\arguments{
\item{target}{Target element.}

\item{...}{Any option to pass to tippy}
}
\description{
Dynamically use tippy.
}
\section{Functions}{

\itemize{
  \item{\code{use_tippy} Includes tippy.js in header.}
  \item{\code{call_tippy} call \code{tippy} on specific target element(s), place after elements to be targeted.}
}
}

\examples{
if(interactive()){
library(shiny)

shinyApp(
  ui = fluidPage(
    use_tippy(),
    p("Some text", title = "tooltip"),
    p("Some text", title = "tooltip"),
    p("Some text", title = "tooltip"),
    p("Some text", title = "tooltip"),
    p("Some text", title = "tooltip"),
    p("Some text", title = "tooltip"),
    call_tippy("[title]") # all elements with title
 ),
 server = function(input, output) {}
)
}

}
\seealso{
\href{https://atomiks.github.io/tippyjs/}{official documentation}
}
