% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tip_with_binary.R
\name{tip_rr_with_binary}
\alias{tip_rr_with_binary}
\title{Tip an observed risk ratio with a binary confounder.}
\usage{
tip_rr_with_binary(
  effect_observed,
  exposed_confounder_prev = NULL,
  unexposed_confounder_prev = NULL,
  confounder_outcome_effect = NULL,
  verbose = TRUE
)
}
\arguments{
\item{effect_observed}{Numeric positive value. Observed exposure - outcome risk ratio.
This can be the point estimate, lower confidence bound, or upper
confidence bound.}

\item{exposed_confounder_prev}{Numeric between 0 and 1. Estimated prevalence of the
unmeasured confounder in the exposed population}

\item{unexposed_confounder_prev}{Numeric between 0 and 1. Estimated prevalence of the
unmeasured confounder in the unexposed population}

\item{confounder_outcome_effect}{Numeric positive value. Estimated relationship
between the unmeasured confounder and the outcome}

\item{verbose}{Logical. Indicates whether to print informative message.
Default: \code{TRUE}}
}
\description{
Choose two of the following three to specify, and the third will be estimated:
\itemize{
\item \code{exposed_confounder_prev}
\item \code{unexposed_confounder_prev}
\item \code{confounder_outcome_effect}
}

Alternatively, specify all three and the function will return the number of unmeasured
confounders specified needed to tip the analysis.
}
