% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_fitsae.R
\name{summary.fitsae}
\alias{summary.fitsae}
\title{Summary Method for \code{fitsae} Objects}
\usage{
\method{summary}{fitsae}(
  object,
  probs = c(0.025, 0.25, 0.5, 0.75, 0.975),
  compute_loo = TRUE,
  ...
)
}
\arguments{
\item{object}{An instance of class \code{fitsae}.}

\item{probs}{A numeric vector of \code{\link[stats]{quantile}}s of interest. 
    The default is \code{c(0.025,0.25,0.5,0.75,0.975)}.}

\item{compute_loo}{Logical, indicating whether to compute \code{\link[loo]{loo}} diagnostics or not.}

\item{...}{Currently unused.}
}
\value{
A list of class \code{summary_fitsae} containing diagnostics objects:
\describe{
\item{\code{raneff}}{A list of \code{data.frame} objects storing the random effects posterior summaries divided for each type: \verb{$unstructured}, \verb{$temporal}, and \verb{$spatial}.}
\item{\code{fixed_coeff}}{Posterior summaries of fixed coefficients.}
\item{\code{var_comp}}{Posterior summaries of model variance parameters.}
\item{\code{model_estimates}}{Posterior summaries of the parameter of interest \eqn{\theta_d} for each in-sample domain \eqn{d}.}
\item{\code{model_estimates_oos}}{Posterior summaries of the parameter of interest \eqn{\theta_d} for each out-of-sample domain \eqn{d}.}
\item{\code{is_oos}}{Logical vector defining whether each domain is out-of-sample or not.}
\item{\code{direct_est}}{Vector of input direct estimates.}
\item{\code{post_means}}{Model-based estimates, i.e. posterior means of the parameter of interest \eqn{\theta_d} for each domain \eqn{d}.}
\item{\code{sd_reduction}}{Standard deviation reduction, see details section.}
\item{\code{sd_dir}}{Standard deviation of direct estimates, given as input if \code{type_disp="var"}.}
\item{\code{loo}}{The object of class \code{loo}, for details see \code{loo} package documentation. }
\item{\code{shrink_rate}}{Shrinking Bound Rate, see details section.}
\item{\code{residuals}}{Residuals related to model-based estimates.}
\item{\code{bayes_pvalues}}{Bayesian p-values obtained via MCMC samples, see details section.}
\item{\code{y_rep}}{An array with values generated from the posterior predictive distribution, enabling the implementation of posterior predictive checks.}
\item{\code{diag_summ}}{Summaries of residuals, standard deviation reduction and Bayesian p-values across the whole domain set.}
\item{\code{data_obj}}{A list containing input objects including in-sample and out-of-sample relevant quantities.}
\item{\code{model_settings}}{A list summarizing all the assumptions of the input model: sampling likelihood, presence of intercept, dispersion parametrization, random effects priors and possible structures.}
\item{\code{call}}{Image of the function call that produced the input \code{fitsae} object.}
}
}
\description{
Summarizing the small area model fitting through the distributions of estimated parameters and derived diagnostics using posterior draws.
}
\details{
If printed, the produced summary displays: \itemize{\item Posterior summaries about the fixed effect coefficients and the scale parameters related to unstructured and possible structured random effects. \item Model diagnostics summaries of (a) model residuals; (b) standard deviation reductions; (c) Bayesian P-values obtained with the MCMC samples. \item Shrinking Bound Rate. \item \code{\link[loo]{loo}} information criteria and related diagnostics from the \code{loo} package.}
}
\examples{
library(tipsae)

# loading toy dataset
data("emilia_cs")

# fitting a model
fit_beta <- fit_sae(formula_fixed = hcr ~ x, data = emilia_cs, domains = "id",
                    type_disp = "var", disp_direct = "vars", domain_size = "n",
                    # MCMC setting to obtain a fast example. Remove next line for reliable results.
                    chains = 1, iter = 150, seed = 0)

# check model diagnostics via summary() method
summ_beta <- summary(fit_beta)
summ_beta
}
\references{
\insertRef{janicki2020properties}{tipsae}

\insertRef{vehtari2017practical}{tipsae}
}
\seealso{
\code{\link{fit_sae}} to estimate the model and the generic methods \code{\link{plot.summary_fitsae}} and \code{\link{density.summary_fitsae}}, and functions \code{\link{map}}, \code{\link{benchmark}} and \code{\link{extract}}.
}
