% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{tkRplot}
\alias{tkRplot}
\alias{tkRreplot}
\alias{.tkRreplot}
\title{Tk Rplot With Resizing}
\usage{
tkRplot(W, fun, width = 490, height = 490, ...)
tkRreplot(W, fun, width, height,  ...)
.tkRreplot(W)
}
\arguments{
\item{W}{Tk toplevel window}

\item{fun}{function to produce the plot}

\item{width}{image width}

\item{height}{image height}

\item{...}{additional arguments}
}
\description{
Dispaly a plot in a Tk toplevel window.
}
\examples{
\dontshow{
 if (.isTclImgOk()){
 bb <- 1
tkbb <- tclVar(1)
tt <- tktoplevel()
tt <- tkRplot(tt, function() {
 x <- 1:20 / 20
   plot(
   x,
   x ^ bb,
   col = "#0000ff50",
       xlab = "x",
           ylab = paste0("x^", bb),
               type = "l",
                   axes = FALSE,
                       lwd = 4)
   title(main = bb)
     points(x,
      x ^ bb,
      col = "#ff000050",
      pch = 19,
      cex = 2)
        axis(1)
        axis(2)
          box()
          })

 f <- function(...) {
 b <- as.numeric(tclvalue(tkbb))
   if (b != bb) {
       bb <<- b
           tkRreplot(tt)
             }
     }

     s <-
       tkscale(
       tt,
       command = f,
       from = 0.05,
       to = 2.00,
       variable = tkbb,
       showvalue = FALSE,
       resolution = 0.05,
       orient = "horiz"
       )

       tkpack(s,
       side = "bottom",
       expand = FALSE,
       before = tt$env$canvas,
       fill = "both")

       Sys.sleep(1)
       tkdestroy(tt)
       }
}
\dontrun{
bb <- 1
tkbb <- tclVar(1)
tt <- tktoplevel()
f <- function(...) {
 b <- as.numeric(tclvalue(tkbb))
   if (b != bb) {
       bb <<- b
           tkRreplot(tt)
             }
     }

tt <- tkRplot(tt, function() {
 x <- 1:20 / 20
   plot(
   x,
   x ^ bb,
   col = "#0000ff50",
       xlab = "x",
           ylab = paste0("x^", bb),
               type = "l",
                   axes = FALSE,
                       lwd = 4)
   title(main = bb)
     points(x,
      x ^ bb,
      col = "#ff000050",
      pch = 19,
      cex = 2)
        axis(1)
        axis(2)
          box()
          })

  s <- tkscale(
       tt,
       command = f,
       from = 0.05,
       to = 2.00,
       variable = tkbb,
       showvalue = TRUE,
       resolution = 0.01,
       repeatdelay = 50,
       repeatinterval = 100,
       orient = "horiz"
       )

       tkpack(s,
       side = "bottom",
       expand = FALSE,
       before = tt$env$canvas,
       fill = "both")

}
}
