% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/tm_layers.R
\name{tm_fill}
\alias{tm_fill}
\title{Fill polygons}
\usage{
tm_fill(col = "grey85", alpha = NA, palette = NULL,
  convert2density = FALSE, area = NULL, n = 5, style = "pretty",
  breaks = NULL, labels = NULL, auto.palette.mapping = TRUE,
  contrast = 1, max.categories = 12, colorNA = "grey60",
  textNA = "Missing", thres.poly = 1e-05)
}
\arguments{
\item{col}{either a single color value or the name of a data variable that is contained in \code{shp}. In the latter case, either the data variable contains color values, or values (numeric or categorical) that will be depicted by a color palette (see \code{palette}. In the latter case, a choropleth is drawn.}

\item{alpha}{transparency number between 0 (totally transparent) and 1 (not transparent). By default, the alpha value of the \code{col} is used (normally 1).}

\item{palette}{palette name. See \code{RColorBrewer::display.brewer.all()} for options. Use a \code{"-"} as prefix to reverse the palette. By default, \code{"RdYlGn"} is taken for numeric variables and \code{"Dark2"} for categorical variables.}

\item{convert2density}{boolean that determines whether \code{col} is converted to a density variable. Should be \code{TRUE} when \code{col} consists of absolute numbers. The area size is either approximated from the shape object, or given by the argument \code{area}.}

\item{area}{Name of the data variable that contains the area sizes in squared kilometer.}

\item{n}{preferred number of classes (in case \code{col} is a numeric variable)}

\item{style}{method to cut the color scale (in case \code{col} is a numeric variable): e.g. "fixed", "equal", "pretty", "quantile", or "kmeans". See the details in \code{\link[classInt:classIntervals]{classIntervals}}.}

\item{breaks}{in case \code{style=="fixed"}, breaks should be specified}

\item{labels}{labels of the classes}

\item{auto.palette.mapping}{When diverging colour palettes are used (i.e. "RdBu") this method automatically maps colors to values such that the middle colors (mostly white or yellow) are assigned to values of 0, and the two sides of the color palette are assigned to negative respectively positive values.}

\item{contrast}{number between 0 and 1 (default) that determines the contrast of the palette. Only applicable when \code{auto.palette.mapping=TRUE}}

\item{max.categories}{in case \code{col} is the name of a categorical variable, this value determines how many categories (levels) it can have maximally. If the number of levels is higher than \code{max.categories}, then levels are combined.}

\item{colorNA}{color used for missing values}

\item{textNA}{text used for missing values. Use \code{NA} to omit text for missing values in the legend}

\item{thres.poly}{number that specifies the threshold at which polygons are taken into account. The number itself corresponds to the proportion of the area sizes of the polygons to the total polygon size.}
}
\value{
\code{\link{tmap-element}}
}
\description{
Creates a \code{\link{tmap-element}} that fills polygons. Either a fixed color is used, or a color palette is mapped to a data variable. By default, a divering color palette is used for numeric variables and a qualitative palette for categorical variables.
}
\examples{
data(World)
data(Europe)
data(NLD_muni)
data(NLD_prov)


# Constant fill
tm_shape(World) + tm_fill("darkolivegreen3") + tm_layout_World(title="A green World")

# Data variable containing colours values
Europe$isNLD <- ifelse(Europe$name=="Netherlands", "darkorange", "darkolivegreen3")
tm_shape(Europe) +
	tm_fill("isNLD") +
	tm_layout("Find the Netherlands!")

# Numeric data variable
tm_shape(Europe) +
	tm_fill("gdp_cap_est", style="kmeans", textNA = "Non-European countries") +
	tm_borders() +
	tm_text("iso_a3", cex="AREA", root=4, scale=2) +
	tm_layout_Europe("GDP per capita")

tm_shape(World) +
    tm_fill("pop_est_dens", style="kmeans", palette="YlOrRd") +
    tm_borders() +
    tm_text("iso_a3", cex="AREA", cex.lowerbound=.4) +
tm_layout_World(title="Population density per km2")


# Categorical data variable
tm_shape(World) +
    tm_fill("income_grp", palette="-Blues") +
    tm_borders() +
    tm_text("iso_a3", cex="AREA", scale=1.5) +
tm_layout_World("Income classification")

tm_shape(NLD_prov) + 
    tm_fill("name") + 
tm_shape(NLD_muni) + 
    tm_borders() + 
tm_shape(NLD_prov) + 
    tm_borders(lwd=2) +
    tm_text("name", shadow=TRUE) +
tm_layout_NLD("Provinces and municipalities", legend.show=FALSE, bg.color="white")

}
\seealso{
\href{../doc/tmap-nutshell.html}{\code{vignette("tmap-nutshell")}}
}

