% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_misc_elements.R
\name{tm_facets}
\alias{tm_facets}
\title{Small multiples}
\usage{
tm_facets(by = NULL, along = NULL, ncol = NA, nrow = NA,
  free.coords = TRUE, drop.units = free.coords, drop.empty.facets = TRUE,
  sync = !free.coords, showNA = NA, textNA = "Missing",
  free.scales = is.null(by) && is.null(along),
  free.scales.fill = free.scales, free.scales.symbol.size = free.scales,
  free.scales.symbol.col = free.scales,
  free.scales.symbol.shape = free.scales,
  free.scales.text.size = free.scales, free.scales.text.col = free.scales,
  free.scales.line.col = free.scales, free.scales.line.lwd = free.scales,
  free.scales.raster = free.scales, inside.original.bbox = FALSE,
  scale.factor = 2, drop.shapes = drop.units)
}
\arguments{
\item{by}{data variable name by which the data is split, or a vector of two variable names to split the data by two variables (where the first is used for the rows and the second for the columns).}

\item{along}{data variable name by which the data is split and plotted on separate pages. This is especially useful for animations made with \code{\link{animation_tmap}}. The \code{along} argument can be used in combination with the \code{by} argument. It is only supported in \code{"plot"} mode (so not in \code{"view"} mode).}

\item{ncol}{number of columns of the small multiples grid. Not applicable if \code{by} contains two variable names.}

\item{nrow}{number of rows of the small multiples grid. Not applicable if \code{by} contains two variable names.}

\item{free.coords}{logical. If the \code{by} argument is specified, should each map has its own coordinate ranges?}

\item{drop.units}{logical. If the \code{by} argument is specified, should non-selected spatial units be dropped? If \code{FALSE} (default), they are plotted where mapped aesthetics are regared as missing values. Not applicable for raster shapes.}

\item{drop.empty.facets}{logical. If the \code{by} argument is specified, should empty facets be dropped? Empty facets occur when the \code{by}-variable contains unused levels. When \code{TRUE} and two \code{by}-variables are specified, empty rows and colums are dropped.}

\item{sync}{logical. Should the navigation in view mode (zooming and panning) be synchronized? By default \code{TRUE}, unless \code{free.coords} is set to \code{TRUE}.}

\item{showNA}{If the \code{by} argument is specified, should missing values of the \code{by}-variable be shown in a facet? If two \code{by}-variables are specified, should missing values be shown in an additional row and column? If \code{NA}, missing values only are shown if they exist. Similar to the \code{useNA} argument of \code{\link[base:table]{table}}, where \code{TRUE}, \code{FALSE}, and \code{NA} correspond to \code{"always"}, \code{"no"}, and \code{"ifany"} respectively.}

\item{textNA}{text used for facets of missing values.}

\item{free.scales}{logical. Should all scales of the plotted data variables be free, i.e. independent of each other? Possible data variables are color from \code{\link{tm_fill}}, color and size from \code{\link{tm_symbols}} and line color from \code{\link{tm_lines}}.}

\item{free.scales.fill}{logical. Should the color scale for the choropleth be free?}

\item{free.scales.symbol.size}{logical. Should the symbol size scale for the symbol map be free?}

\item{free.scales.symbol.col}{logical. Should the color scale for the symbol map be free?}

\item{free.scales.symbol.shape}{logical. Should the symbol shape scale for the symbol map be free?}

\item{free.scales.text.size}{logical. Should the text size scale be free?}

\item{free.scales.text.col}{logical. Should the text color scale be free?}

\item{free.scales.line.col}{Should the line color scale be free?}

\item{free.scales.line.lwd}{Should the line width scale be free?}

\item{free.scales.raster}{Should the color scale for raster layers be free?}

\item{inside.original.bbox}{If \code{free.coords}, should the bounding box of each small multiple be inside the original bounding box?}

\item{scale.factor}{Number that determines how the elements (e.g. font sizes, symbol sizes, line widths) of the small multiples are scaled in relation to the scaling factor of the shapes. The elements are scaled to the \code{scale.factor}th root of the scaling factor of the shapes. So, for \code{scale.factor=1}, they are scaled proportional to the scaling of the shapes. Since elements, especially text, are often too small to read, a higher value is recommended. By default, \code{scale.factor=2}.}

\item{drop.shapes}{deprecated: renamed to \code{drop.units}}
}
\value{
\code{\link{tmap-element}}
}
\description{
Creates a \code{\link{tmap-element}} that specifies facets (small multiples). Small multiples can be created in two ways: 1) by specifying the \code{by} argument with one or two variable names, by which the data is grouped, 2) by specifying multiple variable names in any of the aesthetic argument of the layer functions (for instance, the argument \code{col} in \code{\link{tm_fill}}). This function further specifies the facets, for instance number of rows and columns, and whether the coordinate and scales are fixed or free (i.e. independent of each other).
}
\details{
The global option \code{tmap.limits} controlls the limit of the number of facets that are plotted. By default, \code{tmap_options(tmap.limits=c(facets.plot=64, facets.view=4))}. The maximum number of interactive facets is set to four since otherwise it may become very slow.
}
\examples{
data(World, Europe, NLD_muni, NLD_prov, land, metro)

current.mode <- tmap_mode("plot") # small multiples don't work in view mode

# Facets defined by constant values
tm_shape(World) +
    tm_fill(c("forestgreen", "goldenrod")) +
tm_format_World(title=c("A green world", "A dry world"), bg.color="lightskyblue2", 
    title.position=c("left", "bottom"))

# Facets defined by multiple variables
tm_shape(Europe) +
    tm_polygons(c("well_being", "life_exp"), 
    	style=c("pretty", "fixed"), breaks=list(NULL, c(65,70,75,80,85)), 
    	palette=list("Oranges", "Purples"),
    	border.col = "black",
        title=c("Well-Being Index", "Life Expectancy")) +
tm_format_Europe()

\dontrun{
tm_shape(NLD_muni) +
    tm_fill(c("pop_0_14", "pop_15_24", "pop_25_44", "pop_45_64", "pop_65plus"),
        style="kmeans", 
        palette=list("Oranges", "Greens", "Blues", "Purples", "Greys"),
        title=c("Population 0 to 14", "Population 15 to 24", "Population 25 to 44",
            "Population 45 to 64", "Population 65 and older")) +
tm_shape(NLD_prov) +
    tm_borders() +
tm_format_NLD(frame = TRUE, asp=0)
}

# Facets defined by groupings
tm_shape(NLD_prov) +
    tm_polygons("gold2") +
    tm_facets(by="name")

\dontrun{
tm_shape(NLD_muni) +
    tm_borders() +
    tm_facets(by="province") +
    tm_fill("population", style="kmeans", convert2density = TRUE) +
tm_shape(NLD_prov) +
    tm_borders(lwd=4) +
    tm_facets(by="name")

tm_shape(land) +
    tm_raster("black") +
    tm_facets(by="cover_cls")
}
	
# Facets defined by groupings defined by two variables
\dontrun{
World$HPI3 <- cut(World$HPI, breaks = c(20, 35, 50, 65), 
    labels = c("HPI low", "HPI medium", "HPI high"))
World$GDP3 <- cut(World$gdp_cap_est, breaks = c(0, 5000, 20000, Inf), 
    labels = c("GDP low", "GDP medium", "GDP high"))

tm_shape(World) + 
	tm_fill("HPI3", palette="Dark2", colorNA="grey90", legend.show = FALSE) + 
	tm_facets(c("HPI3", "GDP3"), showNA=FALSE, free.coords = FALSE)

metro$pop1950cat <- cut(metro$pop1950, breaks=c(0.5, 1, 1.5, 2, 3, 5, 10, 40)*1e6)
metro$pop2020cat <- cut(metro$pop2020, breaks=c(0.5, 1, 1.5, 2, 3, 5, 10, 40)*1e6)

tm_shape(World) +
	tm_fill() +
tm_shape(metro) +
tm_dots("red", size = .5) +
	tm_facets(c("pop1950cat", "pop2020cat"), free.coords = FALSE) +
tm_layout(panel.label.rot = c(0, 90), panel.label.size = 2)
}

# example: Meuse data
\dontrun{
require(sp)
require(tmaptools)
data(meuse)
coordinates(meuse) <- ~x+y
proj4string(meuse) <- get_proj4("rd")

meuse_osm <- read_osm(meuse, ext=1.1)

qtm(meuse_osm) + 
	tm_shape(meuse) +
	tm_bubbles(size=c("cadmium", "copper", "lead", "zinc"),
	    col=c("orange", "orange3", "grey40", "grey70"),
	    border.col="black",
        border.alpha = .75,
        scale=.7)
}

# restore current mode
tmap_mode(current.mode)
}
\seealso{
\href{../doc/tmap-nutshell.html}{\code{vignette("tmap-nutshell")}}
}
