% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_chart.R
\name{tm_chart}
\alias{tm_chart}
\alias{tm_chart_histogram}
\alias{tm_chart_bar}
\alias{tm_chart_donut}
\alias{tm_chart_violin}
\alias{tm_chart_box}
\alias{tm_chart_none}
\alias{tm_chart_heatmap}
\title{Legend charts}
\usage{
tm_chart_histogram(
  breaks,
  plot.axis.x,
  plot.axis.y,
  extra.ggplot2,
  position,
  group_id,
  width,
  height,
  stack,
  z,
  ...
)

tm_chart_bar(
  plot.axis.x,
  plot.axis.y,
  extra.ggplot2,
  position,
  group_id,
  width,
  height,
  stack,
  z,
  ...
)

tm_chart_donut(position, group_id, width, height, stack, z, ...)

tm_chart_violin(position, group_id, width, height, stack, z, ...)

tm_chart_box(position, group_id, width, height, stack, z, ...)

tm_chart_none()

tm_chart_heatmap(position, group_id, width, height, stack, z, ...)
}
\arguments{
\item{breaks}{The breaks of the bins (for histograms)}

\item{plot.axis.x, plot.axis.y}{Should the x axis and y axis be plot?}

\item{extra.ggplot2}{Extra ggplot2 code}

\item{position}{The position specification of the component: an object created with \code{tm_pos_in()} or \code{tm_pos_out()}. Or, as a shortcut, a vector of two values, specifying the x and y coordinates. The first is \code{"left"}, \code{"center"} or \code{"right"} (or upper case, meaning tighter to the map frame), the second \code{"top"}, \code{"center"} or \code{"bottom"}. Numeric values are also supported, where 0, 0 means left bottom and 1, 1 right top. See also \href{https://r-tmap.github.io/tmap/articles/adv_positions}{vignette about positioning}. In case multiple components should be combined (stacked), use \code{group_id} and specify \code{component} in \code{\link[=tm_comp_group]{tm_comp_group()}}.}

\item{group_id}{Component group id name. All components (e.g. legends, titles, etc) with the same \code{group_id} will be grouped. The specifications of how they are placed (e.g. stacking, margins etc.) are determined in \code{\link[=tm_comp_group]{tm_comp_group()}} where its argument \code{id} should correspond to \code{group_id}.}

\item{width, height}{width and height of the component.}

\item{stack}{stack with other map components, either \code{"vertical"} or \code{"horizontal"}.}

\item{z}{z index, e.g. the place of the component relative to the other componets}

\item{...}{passed on to \code{tm_title()}}
}
\description{
Legend charts are small charts that are added to the map, usually in addition to legends.
}
\details{
Note that these charts are different from charts drawn inside the map. Those are called glyphs (to be implemented).
}
\examples{
tm_shape(World) +
  tm_polygons("HPI",
    fill.scale = tm_scale_intervals(),
    fill.chart = tm_chart_histogram())
}
\seealso{
\href{https://r-tmap.github.io/tmap/articles/basics_charts}{Vignette about charts}
}
