% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bb_sp.R
\name{bb_sp}
\alias{bb_earth}
\alias{bb_sp}
\title{Convert bounding box to a spatial polygon}
\usage{
bb_sp(x, projection = NULL, steps = 100, stepsize = NA, as.sf = FALSE)

bb_earth(projection = NULL, stepsize = 1, earth.datum = "WGS84",
  bbx = c(-180, 180, -90, 90), buffer = 1e-06, as.sf = FALSE)
}
\arguments{
\item{x}{object that can be coerced to a bounding box with \code{\link{bb}}}

\item{projection}{projection in which the coordinates of \code{x} are provided, see \code{\link{get_proj4}}. For \code{bb_earth}, \code{projection} is the projection in which the bounding box is returned (if possible).}

\item{steps}{number of intermediate points along the shortest edge of the bounding box. The number of intermediate points along the longest edge scales with the aspect ratio. These intermediate points are needed if the bounding box is plotted in another projection.}

\item{stepsize}{stepsize in terms of coordinates (usually meters when the shape is projected and degrees of longlat coordinates are used). If specified, it overrules \code{steps}}

\item{as.sf}{return object as an \code{sf} object}

\item{earth.datum}{Geodetic datum to determine the earth boundary. By default \code{"WGS84"}, other frequently used datums are \code{"NAD83"} and \code{"NAD27"}. Any other \code{PROJ.4} character string can be used. See \code{\link{get_proj4}}.}

\item{bbx}{boundig box of the earth in a vector of 4 values: min longitude, max longitude, min latitude, max latitude. By default \code{c(-180, 180, -90, 90)}. If for some \code{projection}, a feasible solution does not exist, it may be wise to choose a smaller bbx, e.g. \code{c(-180, 180, -88, 88)}. However, this is also automatically done with the next argument, \code{buffer}.}

\item{buffer}{In order to determine feasible earth bounding boxes in other projections, a buffer is used to decrease the bounding box by a small margin (default \code{1e-06}). This value is subtracted from each the bounding box coordinates. If it still does not result in a feasible bounding box, this procedure is repeated 5 times, where each time the buffer is multiplied by 10. Set \code{buffer=0} to disable this procedure.}
}
\value{
\code{\link[sp:SpatialPolygons]{SpatialPolygons}}
}
\description{
Convert bounding box to a \code{\link[sp:SpatialPolygons]{SpatialPolygons}}. Useful for plotting (see example). The function \code{bb_earth} returns a spatial polygon of the 'boundaries' of the earth, which can also be done in other projections (if a feasible solution exists).
}
\examples{
if (require(tmap)) {
    data(Europe)

    current.mode <- tmap_mode("view")
    qtm(bb_sp(Europe))

    # restore mode
    tmap_mode(current.mode)
}

}

