% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/tmodUtest.R
\name{tmodAUC}
\alias{tmodAUC}
\title{Calculate AUC}
\usage{
tmodAUC(l, ranks, modules = NULL, stat = "AUC", remove.dups = TRUE,
  recalculate.ranks = TRUE, filter = FALSE, mset = "LI")
}
\arguments{
\item{l}{List of gene names corresponding to rows from the ranks matrix}

\item{ranks}{a matrix with ranks, where columns correspond to samples
and rows to genes from the l list}

\item{modules}{optional list of modules for which to make the test}

\item{stat}{Which statistics to generate. Default: AUC}

\item{remove.dups}{Remove duplicate gene names in l and corresponding
rows from ranks}

\item{recalculate.ranks}{Filtering and removing duplicates will also
remove ranks, so that they should be recalculated. Use FALSE if you don't
want this behavior. If unsure, stay with TRUE}

\item{filter}{Remove gene names which have no module assignments}

\item{mset}{Which module set to use. "LI", "DC" or "all" (default: LI)}
}
\value{
A matrix with the same number of columns as "ranks" and as many
rows as there were modules to be tested.
}
\description{
Calculate AUC
}
\details{
tmodAUC calculates the AUC and U statistics. The main purpose of this
function is the use in randomization tests. While tmodCERNOtest and
tmodUtest both calculate, for each module, the enrichment in a single
sorted list of genes, tmodAUC takes any number of such sorted lists. Or,
actually, sortings -- vectors with ranks of the genes in each replicate.
Note that the input for this function
is different from tmodUtest and related functions: the ordering of l
and the matrix ranks does not matter, as long as the matrix ranks
contains the actual rankings. Each column in the ranks matrix is treated as
a separate sample.
}
\examples{
data(tmod)
l <- tmod$GENES$ID
ranks <- 1:length(l)
res <- tmodAUC(l, ranks)
head(res)
}
\seealso{
tmod-package
}

