% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualizations.R
\name{pcaplot}
\alias{pcaplot}
\title{Plot a PCA object returned by prcomp}
\usage{
pcaplot(
  pca,
  components = 1:2,
  group = NULL,
  col = NULL,
  pch = 19,
  cex = 2,
  legend = NULL,
  ...
)
}
\arguments{
\item{pca}{PCA object returned by prcomp}

\item{components}{a vector of length two indicating the components to plot}

\item{group}{a factor determining shapes of the points to show (unless
overriden by pch=...)}

\item{col}{Color for plotting (default: internal palette)}

\item{pch}{Type of character to plot (default: 19)}

\item{cex}{size of the symbols used for plotting}

\item{legend}{draw a legend? If legend is a position (eg. "topright"), then a legend
is drawn. If NULL or if the group parameter is NULL, then not.}

\item{...}{any further parameters will be passed to the plot() function
(e.g. col, cex, ...)}
}
\value{
If group is NULL, then NULL; else a data frame containing
        colors and shapes matching each group
}
\description{
Plot a PCA object returned by prcomp
}
\details{
This is a simplistic function. A much better way is to use the pca2d
function from the pca3d package.
}
