% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_model}
\alias{plot_model}
\title{Plot a Transition Network Model from a Matrix of Edge Weights}
\usage{
plot_model(
  x,
  labels,
  colors,
  edge.labels = TRUE,
  layout = "circle",
  mar = rep(5, 4),
  theme = "colorblind",
  ...
)
}
\arguments{
\item{x}{A square \code{matrix} of edge weights.}

\item{labels}{See \code{\link[qgraph:qgraph]{qgraph::qgraph()}}.}

\item{colors}{See \code{\link[qgraph:qgraph]{qgraph::qgraph()}}.}

\item{edge.labels}{See \code{\link[qgraph:qgraph]{qgraph::qgraph()}}.}

\item{layout}{One of the following:
\itemize{
\item A \code{character} string describing a \code{qgraph} layout.
\item A \code{matrix} of node positions to use, with a row for each node and
\code{x} and \code{y} columns for the node positions.
\item A layout function from \code{igraph}.
}}

\item{mar}{See \code{\link[qgraph:qgraph]{qgraph::qgraph()}}.}

\item{theme}{See \code{\link[qgraph:qgraph]{qgraph::qgraph()}}.}

\item{...}{Additional arguments passed to \code{\link[qgraph:qgraph]{qgraph::qgraph()}}.}
}
\value{
See \code{\link[=plot.tna]{plot.tna()}}.
}
\description{
Plot a Transition Network Model from a Matrix of Edge Weights
}
\examples{
m <- matrix(rexp(25), 5, 5)
plot_model(m)

}
