% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid-proxy.R
\name{grid_proxy_delete_row}
\alias{grid_proxy_delete_row}
\title{Delete row in an existent grid}
\usage{
grid_proxy_delete_row(proxy, rowKey)
}
\arguments{
\item{proxy}{A \code{\link[=datagrid_proxy]{datagrid_proxy()}} or \code{outputId} of the grid.}

\item{rowKey}{Row key of the row to delete, you can find the \code{rowKey} value in \verb{input$<outputId>_data}.}
}
\value{
A \code{datagrid_proxy} object.
}
\description{
Delete row in an existent grid
}
\examples{
library(toastui)
library(shiny)

ui <- fluidPage(
  tags$h2("Delete row in grid via proxy"),
  fluidRow(
    column(
      width = 6,
      datagridOutput("grid"),
      verbatimTextOutput("clicks")
    ),
    column(
      width = 6,
      verbatimTextOutput("output_data")
    )
  )
)

server <- function(input, output, session) {

  dat <- data.frame(
    index = 1:26,
    letter = sample(letters),
    remove = 1:26
  )

  output$grid <- renderDatagrid({
    datagrid(dat, data_as_input = TRUE) \%>\%
      grid_columns("remove", width = 120) \%>\%
      grid_col_button(
        column = "remove",
        inputId = "remove_row",
        label = "Remove",
        icon = icon("trash"),
        status = "danger",
        btn_width = "115px",
        align = "left"
      )
  })

  output$clicks <- renderPrint({
    cat(
      "Removed: ", input$remove_row,
      "\n"
    )
  })

  observeEvent(input$remove_row, {
    data <- input$grid_data
    rowKey <- data$rowKey[data$remove == input$remove_row]
    grid_proxy_delete_row("grid", rowKey)
  })

  output$output_data <- renderPrint({
    input$grid_data
  })

}

if (interactive())
  shinyApp(ui, server)
}
\seealso{
Other datagrid proxy methods: 
\code{\link{datagrid_proxy}()},
\code{\link{grid_proxy_add_row}()}
}
\concept{datagrid proxy methods}
