% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colorize.r
\name{highlight_col}
\alias{highlight_col}
\title{Create a highlight color for a html style attribute}
\usage{
highlight_col(value, col = "yellow")
}
\arguments{
\item{value}{Either a logical vector or a numeric vector with
values between 0 and 1. If a logical vector is used, then tokens
with TRUE will be highlighted (with the color specified in pos_col).
If a numeric vector is used, the value determines the alpha (transparency),
with 0 being fully transparent and 1 being fully colored.}

\item{col}{The color used to highlight}
}
\value{
The string used to specify a color in an html tag attribute
}
\description{
Designed to be used together with the attr_style function.
The return value can directly be used to set the color in
an html tag attribute (e.g., color, background-color)
}
\examples{
highlight_col(c(NA, 0, 0.1,0.5, 1))

## used in combination with attr_style()
attr_style(color = highlight_col(c(NA, 0, 0.1,0.5, 1)))

## note that for background-color you need inversed quotes to deal
## with the hyphen in an argument name
attr_style(`background-color` = highlight_col(c(NA, 0, 0.1,0.5, 1)))

tag_attr(class = c(1, 2),
         style = attr_style(`background-color` = highlight_col(c(FALSE,TRUE))))
}
