% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic-tokenizers.R
\name{basic-tokenizers}
\alias{basic-tokenizers}
\alias{tokenize_characters}
\alias{tokenize_lines}
\alias{tokenize_paragraphs}
\alias{tokenize_regex}
\alias{tokenize_sentences}
\alias{tokenize_words}
\title{Basic tokenizers}
\usage{
tokenize_characters(x, lowercase = TRUE, strip_non_alphanum = TRUE,
  simplify = FALSE)

tokenize_words(x, lowercase = TRUE, stopwords = NULL, simplify = FALSE)

tokenize_sentences(x, lowercase = FALSE, strip_punctuation = FALSE,
  simplify = FALSE)

tokenize_lines(x, simplify = FALSE)

tokenize_paragraphs(x, paragraph_break = "\\n\\n", simplify = FALSE)

tokenize_regex(x, pattern = "\\\\s+", simplify = FALSE)
}
\arguments{
\item{x}{A character vector or a list of character vectors to be tokenized
into n-grams. If \code{x} is a character vector, it can be of any length,
and each element will be tokenized separately. If \code{x} is a list of
character vectors, where each element of the list should have a length of
1.}

\item{lowercase}{Should the tokens be made lower case? The default value
varies by tokenizer; it is only \code{TRUE} by default for the tokenizers
that you are likely to use last.}

\item{strip_non_alphanum}{Should punctuation and white space be stripped?}

\item{simplify}{\code{FALSE} by default so that a consistent value is
returned regardless of length of input. If \code{TRUE}, then an input with
a single element will return a character vector of tokens instead of a
list.}

\item{stopwords}{A character vector of stop words to be excluded}

\item{strip_punctuation}{Should punctuation be stripped?}

\item{paragraph_break}{A string identifying the boundary between two
paragraphs.}

\item{pattern}{A regular expression that defines the split}
}
\value{
A list of character vectors containing the tokens, with one element
  in the list for each element that was passed as input. If `simplify = TRUE`
  and only a single element was passed as input, then the output is a
  character vector of tokens.
}
\description{
These functions perform basic tokenization into words, sentences, paragraphs,
lines, and characters. The functions can be piped into one another to create
at most two levels of tokenization. For instance, one might split a text into
paragraphs and then word tokens, or into sentences and then word tokens.
}
\examples{
song <-  paste0("How many roads must a man walk down\\n",
                "Before you call him a man?\\n",
                "How many seas must a white dove sail\\n",
                "Before she sleeps in the sand?\\n",
                "\\n",
                "How many times must the cannonballs fly\\n",
                "Before they're forever banned?\\n",
                "The answer, my friend, is blowin' in the wind.\\n",
                "The answer is blowin' in the wind.\\n")

tokenize_words(song)
tokenize_sentences(song)
tokenize_paragraphs(song)
tokenize_lines(song)
tokenize_characters(song)
tokenize_regex("A,B,C,D,E", pattern = ",")
}

