% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tf_df_dist.R
\name{tf_df_dist}
\alias{tf_df_dist}
\title{Calculate the distance between token and document frequencies}
\usage{
tf_df_dist(topic_model, dtm_data, top_n_tokens = 10)
}
\arguments{
\item{topic_model}{a fitted topic model object from one of the following:
\code{\link[topicmodels]{tm-class}}}

\item{dtm_data}{a document-term matrix of token counts coercible to \code{simple_triplet_matrix}}

\item{top_n_tokens}{an integer indicating the number of top words to consider,
the default is 10}
}
\value{
A vector of distances with length equal to the number of topics in the fitted model
}
\description{
Using the the N highest probability tokens for each topic,
calculate the Hellinger distance between the token frequencies and
the document frequencies
}
\examples{

# Using the example from the LDA function
library(topicmodels)
data("AssociatedPress", package = "topicmodels")
lda <- LDA(AssociatedPress[1:20,], control = list(alpha = 0.1), k = 2)
tf_df_dist(lda, AssociatedPress[1:20,])
}
\references{
{
  Jordan Boyd-Graber, David Mimno, and David Newman, 2014.
  \emph{Care and Feeding of Topic Models: Problems, Diagnostics, and Improvements.}
  CRC Handbooks ofModern Statistical Methods. CRC Press, Boca Raton, Florida.
}
}
