% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linalg.R
\name{linalg_cholesky}
\alias{linalg_cholesky}
\title{Computes the Cholesky decomposition of a complex Hermitian or real symmetric positive-definite matrix.}
\usage{
linalg_cholesky(A)
}
\arguments{
\item{A}{(Tensor): tensor of shape \verb{(*, n, n)} where \code{*} is zero or more batch dimensions
consisting of symmetric or Hermitian positive-definite matrices.}
}
\description{
Letting \teqn{\mathbb{K}} be \teqn{\mathbb{R}} or \teqn{\mathbb{C}},
the \strong{Cholesky decomposition} of a complex Hermitian or real symmetric positive-definite matrix
\teqn{A \in \mathbb{K}^{n \times n}} is defined as
}
\details{
\Sexpr[results=rd, stage=build]{torch:::math_to_rd("
A = LL^{H}\\\\mathrlap{\\\\qquad L \\\\in \\\\mathbb{K}^{n \\\\times n}}
")}

where \teqn{L} is a lower triangular matrix and
\teqn{L^{H}} is the conjugate transpose when \teqn{L} is complex, and the
transpose when \teqn{L} is real-valued.

Supports input of float, double, cfloat and cdouble dtypes.
Also supports batches of matrices, and if \code{A} is a batch of matrices then
the output has the same batch dimensions.
}
\examples{
if (torch_is_installed()) {
a <- torch_eye(10)
linalg_cholesky(a)
}
}
\seealso{
\itemize{
\item \code{\link[=linalg_cholesky_ex]{linalg_cholesky_ex()}} for a version of this operation that
skips the (slow) error checking by default and instead returns the debug
information. This makes it a faster way to check if a matrix is
positive-definite.
\code{\link[=linalg_eigh]{linalg_eigh()}} for a different decomposition of a Hermitian matrix.
The eigenvalue decomposition gives more information about the matrix but it
slower to compute than the Cholesky decomposition.
}

Other linalg: 
\code{\link{linalg_cholesky_ex}()},
\code{\link{linalg_det}()},
\code{\link{linalg_eig}()},
\code{\link{linalg_eigh}()},
\code{\link{linalg_eigvals}()},
\code{\link{linalg_eigvalsh}()},
\code{\link{linalg_householder_product}()},
\code{\link{linalg_inv}()},
\code{\link{linalg_inv_ex}()},
\code{\link{linalg_lstsq}()},
\code{\link{linalg_matrix_norm}()},
\code{\link{linalg_matrix_power}()},
\code{\link{linalg_matrix_rank}()},
\code{\link{linalg_multi_dot}()},
\code{\link{linalg_norm}()},
\code{\link{linalg_pinv}()},
\code{\link{linalg_qr}()},
\code{\link{linalg_slogdet}()},
\code{\link{linalg_solve}()},
\code{\link{linalg_solve_triangular}()},
\code{\link{linalg_svd}()},
\code{\link{linalg_svdvals}()},
\code{\link{linalg_tensorinv}()},
\code{\link{linalg_tensorsolve}()},
\code{\link{linalg_vector_norm}()}
}
\concept{linalg}
