% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-activation.R
\name{nn_softplus}
\alias{nn_softplus}
\title{Softplus module}
\usage{
nn_softplus(beta = 1, threshold = 20)
}
\arguments{
\item{beta}{the \eqn{\beta} value for the Softplus formulation. Default: 1}

\item{threshold}{values above this revert to a linear function. Default: 20}
}
\description{
Applies the element-wise function:
\deqn{
  \mbox{Softplus}(x) = \frac{1}{\beta} * \log(1 + \exp(\beta * x))
}
}
\details{
SoftPlus is a smooth approximation to the ReLU function and can be used
to constrain the output of a machine to always be positive.
For numerical stability the implementation reverts to the linear function
when \eqn{input \times \beta > threshold}.
}
\section{Shape}{

\itemize{
\item Input: \eqn{(N, *)} where \code{*} means, any number of additional
dimensions
\item Output: \eqn{(N, *)}, same shape as the input
}
}

\examples{
if (torch_is_installed()) {
m <- nn_softplus()
input <- torch_randn(2)
output <- m(input)

}
}
