% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-activation.R
\name{nn_prelu}
\alias{nn_prelu}
\title{PReLU module}
\usage{
nn_prelu(num_parameters = 1, init = 0.25)
}
\arguments{
\item{num_parameters}{(int): number of \eqn{a} to learn.
Although it takes an int as input, there is only two values are legitimate:
1, or the number of channels at input. Default: 1}

\item{init}{(float): the initial value of \eqn{a}. Default: 0.25}
}
\description{
Applies the element-wise function:
\deqn{
  \mbox{PReLU}(x) = \max(0,x) + a * \min(0,x)
}
or
\deqn{
  \mbox{PReLU}(x) =
  \left\{ \begin{array}{ll}
x, & \mbox{ if } x \geq 0 \\
ax, & \mbox{ otherwise }
\end{array}
\right.
}
}
\details{
Here \eqn{a} is a learnable parameter. When called without arguments, \code{nn.prelu()} uses a single
parameter \eqn{a} across all input channels. If called with \code{nn_prelu(nChannels)},
a separate \eqn{a} is used for each input channel.
}
\note{
weight decay should not be used when learning \eqn{a} for good performance.

Channel dim is the 2nd dim of input. When input has dims < 2, then there is
no channel dim and the number of channels = 1.
}
\section{Shape}{

\itemize{
\item Input: \eqn{(N, *)} where \code{*} means, any number of additional
dimensions
\item Output: \eqn{(N, *)}, same shape as the input
}
}

\section{Attributes}{

\itemize{
\item weight (Tensor): the learnable weights of shape (\code{num_parameters}).
}
}

\examples{
if (torch_is_installed()) {
m <- nn_prelu()
input <- torch_randn(2)
output <- m(input)

}
}
