% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_pinverse}
\alias{torch_pinverse}
\title{Pinverse}
\usage{
torch_pinverse(self, rcond = 1e-15)
}
\arguments{
\item{self}{(Tensor) The input tensor of size \eqn{(*, m, n)} where \eqn{*} is zero or more batch dimensions}

\item{rcond}{(float) A floating point value to determine the cutoff for small singular values.                   Default: 1e-15}
}
\description{
Pinverse
}
\note{
\preformatted{This method is implemented using the Singular Value Decomposition.
}

\preformatted{The pseudo-inverse is not necessarily a continuous function in the elements of the matrix `[1]`_.
Therefore, derivatives are not always existent, and exist for a constant rank only `[2]`_.
However, this method is backprop-able due to the implementation by using SVD results, and
could be unstable. Double-backward will also be unstable due to the usage of SVD internally.
See `~torch.svd` for more details.
}
}
\section{pinverse(input, rcond=1e-15) -> Tensor }{


Calculates the pseudo-inverse (also known as the Moore-Penrose inverse) of a 2D tensor.
Please look at \verb{Moore-Penrose inverse}_ for more details
}

\examples{
if (torch_is_installed()) {

input = torch_randn(c(3, 5))
input
torch_pinverse(input)
# Batched pinverse example
a = torch_randn(c(2,6,3))
b = torch_pinverse(a)
torch_matmul(b, a)
}
}
