% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_hstack}
\alias{torch_hstack}
\title{Hstack}
\usage{
torch_hstack(tensors)
}
\arguments{
\item{tensors}{(sequence of Tensors) sequence of tensors to concatenate}
}
\description{
Hstack
}
\section{hstack(tensors, *, out=None) -> Tensor }{


Stack tensors in sequence horizontally (column wise).

This is equivalent to concatenation along the first axis for 1-D tensors, and
along the second axis for all other tensors.
}

\examples{
if (torch_is_installed()) {

a <- torch_tensor(c(1, 2, 3))
b <- torch_tensor(c(4, 5, 6))
torch_hstack(list(a,b))
a <- torch_tensor(rbind(1,2,3))
b <- torch_tensor(rbind(4,5,6))
torch_hstack(list(a,b))
}
}
