% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functional.R
\name{functional_lfilter}
\alias{functional_lfilter}
\title{An IIR Filter (functional)}
\usage{
functional_lfilter(waveform, a_coeffs, b_coeffs, clamp = TRUE)
}
\arguments{
\item{waveform}{(Tensor): audio waveform of dimension of \verb{(..., time)}.  Must be normalized to -1 to 1.}

\item{a_coeffs}{(Tensor): denominator coefficients of difference equation of dimension of \code{(n_order + 1)}.
Lower delays coefficients are first, e.g. \verb{[a0, a1, a2, ...]}.
Must be same size as b_coeffs (pad with 0's as necessary).}

\item{b_coeffs}{(Tensor): numerator coefficients of difference equation of dimension of \code{(n_order + 1)}.
Lower delays coefficients are first, e.g. \verb{[b0, b1, b2, ...]}.
Must be same size as a_coeffs (pad with 0's as necessary).}

\item{clamp}{(bool, optional): If \code{TRUE}, clamp the output signal to be in the range [-1, 1] (Default: \code{TRUE})}
}
\value{
\code{tensor}: Waveform with dimension of \verb{(..., time)}.
}
\description{
Perform an IIR filter by evaluating difference equation.
}
