% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functional.R
\name{functional_treble_biquad}
\alias{functional_treble_biquad}
\title{Treble Tone-control Effect (functional)}
\usage{
functional_treble_biquad(
  waveform,
  sample_rate,
  gain,
  central_freq = 3000,
  Q = 0.707
)
}
\arguments{
\item{waveform}{(Tensor): audio waveform of dimension of \verb{(..., time)}}

\item{sample_rate}{(int): sampling rate of the waveform, e.g. 44100 (Hz)}

\item{gain}{(float): desired gain at the boost (or attenuation) in dB.}

\item{central_freq}{(float, optional): central frequency (in Hz). (Default: \code{3000})}

\item{Q}{(float, optional): \url{https://en.wikipedia.org/wiki/Q_factor} (Default: \code{0.707}).}
}
\value{
\code{tensor}: Waveform of dimension of \verb{(..., time)}
}
\description{
Design a treble tone-control effect.  Similar to SoX implementation.
}
\references{
\itemize{
\item \url{https://sox.sourceforge.net/sox.html}
\item \url{https://webaudio.github.io/Audio-EQ-Cookbook/audio-eq-cookbook.html}
}
}
