% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vision_utils.R
\name{draw_bounding_boxes}
\alias{draw_bounding_boxes}
\title{Draws bounding boxes on image.}
\usage{
draw_bounding_boxes(
  image,
  boxes,
  labels = NULL,
  colors = NULL,
  fill = FALSE,
  width = 1,
  font = c("serif", "plain"),
  font_size = 10
)
}
\arguments{
\item{image}{: Tensor of shape (C x H x W) and dtype uint8.}

\item{boxes}{: Tensor of size (N, 4) containing bounding boxes in (xmin, ymin, xmax, ymax) format. Note that
the boxes are absolute coordinates with respect to the image. In other words: \verb{0  = xmin < xmax < W} and
\verb{0  = ymin < ymax < H}.}

\item{labels}{: character vector containing the labels of bounding boxes.}

\item{colors}{: character vector containing the colors
of the boxes or single color for all boxes. The color can be represented as
strings e.g. "red" or "#FF00FF". By default, viridis colors are generated for boxes.}

\item{fill}{: If \code{TRUE} fills the bounding box with specified color.}

\item{width}{: Width of text shift to the bounding box.}

\item{font}{: NULL for the current font family, or a character vector of length 2 for Hershey vector fonts.}

\item{font_size}{: The requested font size in points.}
}
\value{
torch_tensor of size (C, H, W) of dtype uint8: Image Tensor with bounding boxes plotted.
}
\description{
Draws bounding boxes on top of one image tensor
}
\examples{
if (torch::torch_is_installed()) {
image <- torch::torch_randint(170, 250, size = c(3, 360, 360))$to(torch::torch_uint8())
x <- torch::torch_randint(low = 1, high = 160, size = c(12,1))
y <- torch::torch_randint(low = 1, high = 260, size = c(12,1))
boxes <- torch::torch_cat(c(x, y, x + 20, y +  10), dim = 2)
bboxed <- draw_bounding_boxes(image, boxes, colors = "black", fill = TRUE)
tensor_image_browse(bboxed)
}
}
