% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vision_utils.R
\name{vision_make_grid}
\alias{vision_make_grid}
\title{A simplified version of torchvision.utils.make_grid}
\usage{
vision_make_grid(
  tensor,
  scale = TRUE,
  num_rows = 8,
  padding = 2,
  pad_value = 0
)
}
\arguments{
\item{tensor}{tensor of shape (B x C x H x W) to arrange in grid.}

\item{scale}{whether to normalize (min-max-scale) the input tensor.}

\item{num_rows}{number of rows making up the grid (default 8).}

\item{padding}{amount of padding between batch images (default 2).}

\item{pad_value}{pixel value to use for padding.}
}
\value{
a 3d torch_tensor of shape \eqn{\approx(C , num\_rows \times H , num\_cols \times W)} of all images arranged in a grid.
}
\description{
Arranges a batch B of (image) tensors in a grid, with optional padding between
images. Expects a 4d mini-batch tensor of shape (B x C x H x W).
}
\seealso{
Other image display: 
\code{\link{draw_bounding_boxes}()},
\code{\link{draw_keypoints}()},
\code{\link{draw_segmentation_masks}()},
\code{\link{tensor_image_browse}()},
\code{\link{tensor_image_display}()}
}
\concept{image display}
