% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LDAgen.R
\name{LDAgen}
\alias{LDAgen}
\title{Function to fit LDA model}
\usage{
LDAgen(documents, K = 100L, vocab, num.iterations = 200L,
  burnin = 70L, alpha = NULL, eta = NULL, seed = NULL,
  folder = file.path(tempdir(), "lda-result"), num.words = 50L,
  LDA = TRUE, count = FALSE)
}
\arguments{
\item{documents}{A list prepared by \code{\link{LDAprep}}.}

\item{K}{Number of topics}

\item{vocab}{Character vector containing the words in the corpus}

\item{num.iterations}{Number of iterations for the gibbs sampler}

\item{burnin}{Number of iterations for the burnin}

\item{alpha}{Hyperparameter for the topic proportions}

\item{eta}{Hyperparameter for the word distributions}

\item{seed}{A seed for reproducability.}

\item{folder}{File for the results. Saves in the temporary directionary by default.}

\item{num.words}{Number of words in the top topic words list}

\item{LDA}{logical: Should a new model be fitted or an existing R workspace?}

\item{count}{logical: Should article counts calculated
per top topic words be used for output as csv
(default: \code{FALSE})?}
}
\value{
A .csv file containing the topword list and a R workspace containing the
result data.
}
\description{
This function uses the \code{\link[lda]{lda.collapsed.gibbs.sampler}} from the lda-
package and additionally saves topword lists and a R workspace.
}
\examples{
texts <- list(A="Give a Man a Fish, and You Feed Him for a Day.
Teach a Man To Fish, and You Feed Him for a Lifetime",
B="So Long, and Thanks for All the Fish",
C="A very able manipulative mathematician, Fisher enjoys a real mastery
in evaluating complicated multiple integrals.")

corpus <- textmeta(meta=data.frame(id=c("A", "B", "C", "D"),
title=c("Fishing", "Don't panic!", "Sir Ronald", "Berlin"),
date=c("1885-01-02", "1979-03-04", "1951-05-06", "1967-06-02"),
additionalVariable=1:4, stringsAsFactors=FALSE), text=texts)

corpus <- cleanTexts(corpus)
wordlist <- makeWordlist(corpus$text)
ldaPrep <- LDAprep(text=corpus$text, vocab=wordlist$words)

\donttest{LDAgen(documents=ldaPrep, K = 3L, vocab=wordlist$words, num.words=3)}

}
\references{
Blei, David M. and Ng, Andrew and Jordan, Michael. Latent
Dirichlet allocation. Journal of Machine Learning Research, 2003.

Jonathan Chang (2012). lda: Collapsed Gibbs sampling methods for topic
models.. R package version 1.3.2. http://CRAN.R-project.org/package=lda
}
\seealso{
Documentation for the lda package.
}
