% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_locals.R
\name{function_locals}
\alias{function_locals}
\title{Return function environment as list}
\usage{
function_locals(without = c(), strip_function_args = TRUE)
}
\arguments{
\item{without}{character vector of symbols to exclude}

\item{strip_function_args}{Whether to exclude symbols with the same name as
the function arguments}
}
\value{
The function environment as list
}
\description{
Return current env without function arguments as list. Raises
an error when called outside a function.
}
\details{
The order of the symbols in the returned list is arbitrary.
}
\examples{
f <- function(a = 1, b = 2) {
  x <- 3
  y <- 4
  return(function_locals())
}
all.equal(setdiff(f(), list(x = 3, y = 4)), list())
}
