% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toxbootMySQLFuncs.R
\name{toxbootGetMySQLFields}
\alias{toxbootGetMySQLFields}
\title{Function to query toxboot results from MySQL}
\usage{
toxbootGetMySQLFields(fields = "*", table_name = "toxboot", ...)
}
\arguments{
\item{fields}{a vector specifying which columns to return. Default to '*'
which will return all columns}

\item{table_name}{the name of the table to query. By default 'toxboot'.}

\item{...}{parameters to query on. Format is query_field = query_values.}
}
\description{
\code{toxbootGetMySQLFields} queries the toxboot MySQL table and returns a
data.table with the requested results
}
\details{
Use the fields parameters to specify which columns to return. The
  parameter 'table_name' defaults to 'toxboot' which is the default table for
  writing and reading results. All other parameters will be passed as values
  to select on.
}
\examples{
\dontrun{
toxbootmc(dat = erl3data,
          m4ids = unique(erl3data[, m4id])[1:50],
          boot_method = "smooth",
          destination = "mysql",
          replicates = 10,
          cores = 8)
toxbootGetMySQLFields()
toxbootGetMySQLFields(m4id = 1288500)
toxbootGetMySQLFields(m4id = 1288500, fields = c("boot_method", "hill_ga"))
toxbootGetMySQLFields(m4id = 1288500, replicates = 10, fields = c("boot_method", "hill_ga"))
}

}
