% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trackeRdata_plot.R
\name{plotRoute}
\alias{plotRoute}
\title{Plot routes for training sessions.}
\usage{
plotRoute(x, session = 1, zoom = NULL, speed = TRUE, threshold = TRUE,
  ...)
}
\arguments{
\item{x}{A object of class \code{\link{trackeRdata}}.}

\item{session}{The session to be plotted.}

\item{zoom}{The zoom level for the background map as passed on to
\code{\link[ggmap]{get_map}} (2 corresponds roughly to continent
level and 20 to building level).}

\item{speed}{Logical. Should the trace be colored according to speed?}

\item{threshold}{Logical. Should thresholds be applied?}

\item{...}{Additional arguments passed on to \code{\link{threshold}} and
\code{\link[ggmap]{get_map}}, e.g., \code{source} and \code{maptype}.}
}
\description{
Plot the route ran/cycled during training onto a background map.
Internet connection is required to download the background map.
}
\examples{
\dontrun{
data(runs, package = "trackeR")
plotRoute(runs, session = 4, zoom = 13)
plotRoute(runs, session = 4, zoom = 13, maptype = "hybrid")
plotRoute(runs, session = 4, zoom = 13, source = "osm")
}
}
\seealso{
\code{\link[ggmap]{get_map}}, \code{\link[ggmap]{ggmap}}
}

