% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ots_strings_processing.R
\name{ots_commodity_code}
\alias{ots_commodity_code}
\title{String matching of official commodity/section names and Harmonized System (HS) codes
according to the United Nations nomenclature}
\usage{
ots_commodity_code(commodity = NULL, section = NULL)
}
\arguments{
\item{commodity}{A text string such as "Animals", "COPPER" or "fruits".}

\item{section}{A text string such as "meat", "FISH" or "Dairy".}
}
\value{
A tibble with all possible matches (no uppercase distinction)
showing the commodity name and commodity code
}
\description{
Takes a text string and searches within the
package data for all matching commodity codes in the context of valid API
commodity codes.
}
\examples{
ots_commodity_code(commodity = "ANIMALS ")
ots_commodity_code(section = "  fish")
ots_commodity_code(commodity = "Milk", section = "Dairy")
}
\keyword{functions}
