% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train.R
\name{train.ada}
\alias{train.ada}
\title{train.ada}
\usage{
train.ada(formula, data, ..., subset, na.action = na.rpart)
}
\arguments{
\item{formula}{a symbolic description of the model to be fit.}

\item{data}{an optional data frame containing the variables in the model.}

\item{...}{arguments passed to rpart.control. For stumps, use rpart.control(maxdepth=1,cp=-1,minsplit=0,xval=0). maxdepth controls the depth of
trees, and cp controls the complexity of trees. The priors should also be fixed through the parms argument as discussed in the second reference.}

\item{subset}{an optional vector specifying a subset of observations to be used in the fitting process.}

\item{na.action}{a function that indicates how to process ‘NA’ values. Default=na.rpart.}
}
\value{
A object ada.prmdt with additional information to the model that allows to homogenize the results.
}
\description{
Provides a wrapping function for the \code{\link[ada]{ada}}.
}
\note{
the parameter information was taken from the original function \code{\link[ada]{ada}}.
}
\examples{

data("Puromycin")

n <- seq_len(nrow(Puromycin))
.sample <- sample(n, length(n) * 0.75)
data.train <- Puromycin[.sample,]
data.test <- Puromycin[-.sample,]

modelo.ada <- train.ada(state~., data.train)
modelo.ada
prob <- predict(modelo.ada, data.test , type = "prob")
prob
prediccion <- predict(modelo.ada, data.test , type = "class")
prediccion
confusion.matrix(data.test, prediccion)

}
\seealso{
The internal function is from package \code{\link[ada]{ada}}.
}
