% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train.R
\name{train.nnet}
\alias{train.nnet}
\title{train.nnet}
\usage{
train.nnet(formula, data, weights, ..., subset, na.action, contrasts = NULL)
}
\arguments{
\item{formula}{A formula of the form class ~ x1 + x2 + ...}

\item{data}{Data frame from which variables specified in formula are preferentially to be taken.}

\item{weights}{(case) weights for each example – if missing defaults to 1.}

\item{...}{arguments passed to or from other methods.}

\item{subset}{An index vector specifying the cases to be used in the training sample. (NOTE: If given, this argument must be named.)}

\item{na.action}{A function to specify the action to be taken if NAs are found. The default action is for the
procedure to fail. An alternative is na.omit, which leads to rejection of cases with missing
values on any required variable. (NOTE: If given, this argument must be named.)}

\item{contrasts}{a list of contrasts to be used for some or all of the factors appearing as variables in the model formula.}
}
\value{
A object nnet.prmdt with additional information to the model that allows to homogenize the results.
}
\description{
Provides a wrapping function for the \code{\link[nnet]{nnet}}.
}
\note{
the parameter information was taken from the original function \code{\link[nnet]{nnet}}.
}
\examples{

# Classification
data("iris")

n <- seq_len(nrow(iris))
.sample <- sample(n, length(n) * 0.75)
data.train <- iris[.sample,]
data.test <- iris[-.sample,]

modelo.nn <- train.nnet(Species~., data.train, size = 20)
modelo.nn
prob <- predict(modelo.nn, data.test, type = "prob")
prob
prediccion <- predict(modelo.nn, data.test, type = "class")
prediccion

# Regression
len <- nrow(swiss)
sampl <- sample(x = 1:len,size = len*0.20,replace = FALSE)
ttesting <- swiss[sampl,]
ttraining <- swiss[-sampl,]
model.knn <- train.nnet(Infant.Mortality~.,ttraining, size = 20)
prediction <- predict(model.knn, ttesting)
prediction

}
\seealso{
The internal function is from package \code{\link[nnet]{nnet}}.
}
