## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
library(traj)
head(example.data$data)

## ---- eval=FALSE, echo=FALSE--------------------------------------------------
#  head(example.data$time)

## -----------------------------------------------------------------------------
s1 = step1measures(example.data$data, ID = TRUE)
head(s1$measurments)

## -----------------------------------------------------------------------------
s2 = step2factors(s1)
head(s2$factors)

## -----------------------------------------------------------------------------
s3 = step3clusters(s2, nclusters = 4)

## -----------------------------------------------------------------------------
head(s3$clusters)
s3$clust.distr

## -----------------------------------------------------------------------------
plot(s3)

## -----------------------------------------------------------------------------
plotMeanTraj(s3)

## -----------------------------------------------------------------------------
plotMedTraj(s3)

## -----------------------------------------------------------------------------
plotBoxplotTraj(s3)

## -----------------------------------------------------------------------------
plotCombTraj(s3)

