% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dirn_autocorr.R
\name{TrajDAMinMax}
\alias{TrajDAMinMax}
\alias{TrajDAFindFirstMinimum}
\alias{TrajDAFindFirstMaximum}
\title{First direction autocorrelation minimum/maximum}
\usage{
TrajDAFindFirstMinimum(corr, windowSize = 10)

TrajDAFindFirstMaximum(corr, windowSize = 10)
}
\arguments{
\item{corr}{a \code{TrajDirectionAutocorrelations} object, i.e. the direction
autocorrelation of a trajectory.}

\item{windowSize}{Size of window used to define what constitutes a local
mimimum/maximum.}
}
\value{
Numeric vector with 2 values, \code{deltaS} and \code{C}, or else
  NULL if there is no local minimum/maximum.
}
\description{
Determines the coordinates of the first local minimum/maximum of \code{C} in
the direction autocorrelation function of a trajectory as returned by
\code{\link{TrajDirectionAutocorrelations}}. The end point is excluded from
consideration as a minimum, similarly the start point will not be returned as
a maximum. if the trajectory does not osciallate in direction, there will not
be a local minimum/maximum, and \code{NULL} is returned.
}
\examples{
set.seed(42)
trj <- TrajGenerate(600, angularErrorSd = 1)
smoothed <- TrajSmoothSG(trj, 3, 11)

# Resample to fixed path length
resampled <- TrajRediscretize(smoothed, 1)
# Calculate direction autocorrelation for resampled trajectory
corr <- TrajDirectionAutocorrelations(resampled, 100)
# Extract first local minimum from autocorrelation
minPt <- TrajDAFindFirstMinimum(corr, 20)

# Plot the autocorrelation function
plot(corr, type ='l')
# Plot a red dot with a black outline at the first minimum
points(minPt["deltaS"], minPt["C"], pch = 16, col = "red", lwd = 2)
points(minPt["deltaS"], minPt["C"], col = "black", lwd = 2)

}
\seealso{
\code{\link{TrajDirectionAutocorrelations}}
}
