% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.tramME}
\alias{predict.tramME}
\title{Predict method for tramME objects}
\usage{
\method{predict}{tramME}(object, newdata = NULL, ranef = NULL, ...)
}
\arguments{
\item{object}{A tramME object}

\item{newdata}{an optional data frame of observations}

\item{ranef}{Vector of random effects or the word "zero". See details.}

\item{...}{Additional arguments, passed to \code{\link[mlt]{predict.mlt}}.}
}
\value{
A numeric matrix of the predicted values invisibly
}
\description{
Evaluates the _conditional_ distribution implied by a tramME model, given by a
set of covariates and random effects on a desired scale.
When \code{newdata} contains values of the response variable, prediction is only
done for those values. When no response values are supplied, prediction is done on
a grid of values.
Unfitted tramME models can also be used for prediction as long as the coefficent
parameter are set manually (with \code{coef<-}).
}
\details{
When \code{ranef} is equal to "zero", a vector of zeros with the right size is
substituted.
}
\examples{
data("sleepstudy", package = "lme4")
fit <- BoxCoxME(Reaction ~ Days + (Days | Subject), data = sleepstudy)
predict(fit, type = "trafo") ## evaluate on the transformation function scale
nd <- sleepstudy
nd$Reaction <- NULL
pr <- predict(fit, newdata = nd, ranef = ranef(fit, raw = TRUE), type = "distribution",
              K = 100)
}
