% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{residuals.tramME}
\alias{residuals.tramME}
\title{Residuals of a tramME model}
\usage{
\method{residuals}{tramME}(
  object,
  param = c(coef(object, with_baseline = TRUE, fixed = FALSE), varcov(object, as.theta
    = TRUE)),
  newdata = NULL,
  ...
)
}
\arguments{
\item{object}{A \code{tramME} object.}

\item{param}{An optional vector of parameter values in the structure
(beta, theta).}

\item{newdata}{An optional data.frame.}

\item{...}{Optional arguments (currently ignored).}
}
\description{
Calculates the score residuals of an intercept term fixed at 0.
}
\examples{
library("survival")
fit <- SurvregME(Surv(time, status) ~ rx + (1 | litter), data = rats)
resid(fit)
}
