% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{variable.names.tramME}
\alias{variable.names.tramME}
\title{Return variable names.}
\usage{
\method{variable.names}{tramME}(
  object,
  which = c("all", "response", "grouping", "shifting", "interacting", "smooth",
    "ranef"),
  ...
)
}
\arguments{
\item{object}{a tramME object (fitted or unfitted)}

\item{which}{\enumerate{
\item all: all variables,
\item response: response variable,
\item grouping: grouping factors for random effects,
\item shifting: shifting variables,
\item interacting: interacting variables,
\item smooth: variables in smooth terms,
\item ranef: all random effects variables (covariates with random slopes and grouping
factors).
}}

\item{...}{optional parameters}
}
\value{
A vector of variable names.
}
\description{
Returns the variable names corresponding to different variable groups in a tramME
model.
}
\details{
The returned names are the names as they are used by tramME. For example,
when the response is a \code{Surv} object, \code{variable.names} returns
the name of that object, and not the names of the variables used to create it.
}
\examples{
data("sleepstudy", package = "lme4")
mod <- LmME(Reaction ~ Days + (Days | Subject), data = sleepstudy, nofit = TRUE)
variable.names(mod)
variable.names(mod, "response")
}
