% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/liver.R
\name{meld_US}
\alias{meld_US}
\title{MELD score (US units)}
\usage{
meld_US(INR, bili, creat, dialysis)
}
\arguments{
\item{INR}{numeric vector ofINR}

\item{bili}{numeric vector of bilirubin in mg/dl}

\item{creat}{numeric vector of creatinine in mg/dl}

\item{dialysis}{numeric vector of whether on dialysis/CVVH (1 = yes, 0 = no)}
}
\value{
MELD score
}
\description{
A wrapper for the vectorised function meld() to calculate the MELD score, but
using mg/dl for bilirubin and creatinine. If the
patient is on CVVH or has been dialysed at least twice in the same week, the dialysis argument
should be set to 1, which changes the creatinine level used in the formula to 4mg/dl.
Following UNOS guidelines, the values for INR as well bilirubin and creatinine are
set to a minimum value of 1 if less than 1.0
}
\details{
Reference: Kamath PS, Wiesner RH, Malinchoc M, et al. A model to predict survival in patients
with end-stage liver disease. Hepatology 2001; 33:464-470.
}
\examples{
meld_US(INR = 2.0, bili = 2.3, creat = 1.9, dialysis = 1)
}
