% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_map.R
\name{time_map}
\alias{time_map}
\title{Isochrones (Time Map)}
\usage{
time_map(
  departure_searches = NULL,
  arrival_searches = NULL,
  unions = NULL,
  intersections = NULL,
  format = NULL
)
}
\arguments{
\item{departure_searches}{One or more objects created by \code{\link{make_search}}}

\item{arrival_searches}{One or more objects created by \code{\link{make_search}}}

\item{unions}{One or more objects created by \code{\link{make_union_intersect}}}

\item{intersections}{One or more objects created by \code{\link{make_union_intersect}}}

\item{format}{time-map response format. See \url{https://docs.traveltime.com/api/reference/isochrones#Response-Body} for details.}
}
\value{
API response parsed as a list and as a raw json
}
\description{
Given origin coordinates, find shapes of zones reachable within corresponding travel time.
Find unions/intersections between different searches
}
\details{
See \url{https://docs.traveltime.com/api/reference/isochrones/} for details
}
\examples{
\dontrun{

dateTime <- strftime(as.POSIXlt(Sys.time(), "UTC"), "\%Y-\%m-\%dT\%H:\%M:\%SZ")

departure_search1 <-
  make_search(id = "public transport from Trafalgar Square",
              departure_time = dateTime,
              travel_time = 900,
              coords = list(lat = 51.507609, lng = -0.128315),
              transportation = list(type = "public_transport"),
              properties = list('is_only_walking'))

departure_search2 <-
  make_search(id = "driving from Trafalgar Square",
              departure_time = dateTime,
              travel_time = 900,
              coords = list(lat = 51.507609, lng = -0.128315),
              transportation = list(type = "driving"))

arrival_search <-
  make_search(id = "public transport to Trafalgar Square",
              arrival_time = dateTime,
              travel_time = 900,
              coords = list(lat = 51.507609, lng = -0.128315),
              transportation = list(type = "public_transport"),
              range = list(enabled = TRUE, width = 3600))

union <- make_union_intersect(id = "union of driving and public transport",
                               search_ids = list('driving from Trafalgar Square',
                                                 'public transport from Trafalgar Square'))
intersection <- make_union_intersect(id = "intersection of driving and public transport",
                               search_ids = list('driving from Trafalgar Square',
                                                 'public transport from Trafalgar Square'))
result <-
  time_map(
    departure_searches = c(departure_search1, departure_search2),
    arrival_searches = arrival_search,
    unions = union,
    intersections = intersection
  )
}
}
