% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance_map.R
\name{distance_map}
\alias{distance_map}
\title{Distance Map}
\usage{
distance_map(
  departure_searches = NULL,
  arrival_searches = NULL,
  unions = NULL,
  intersections = NULL,
  format = NULL
)
}
\arguments{
\item{departure_searches}{One or more objects created by \code{\link{make_search}}}

\item{arrival_searches}{One or more objects created by \code{\link{make_search}}}

\item{unions}{One or more objects created by \code{\link{make_union_intersect}}}

\item{intersections}{One or more objects created by \code{\link{make_union_intersect}}}

\item{format}{distance-map response format. See \url{https://docs.traveltime.com/api/reference/distance-map#Response-Body} for details.}
}
\value{
API response parsed as a list and as a raw json
}
\description{
Given origin coordinates, find shapes of zones reachable within corresponding travel distance.
Find unions/intersections between different searches
}
\details{
See \url{https://docs.traveltime.com/api/reference/distance-map/} for details
}
\examples{
\dontrun{

dateTime <- strftime(as.POSIXlt(Sys.time(), "UTC"), "\%Y-\%m-\%dT\%H:\%M:\%SZ")

departure_search <-
  make_search(id = "driving from Trafalgar Square",
              departure_time = dateTime,
              travel_distance = 900,
              coords = list(lat = 51.507609, lng = -0.128315),
              transportation = list(type = "driving"))

arrival_search <-
  make_search(id = "driving to Trafalgar Square",
              arrival_time = dateTime,
              travel_distance = 900,
              coords = list(lat = 51.507609, lng = -0.128315),
              transportation = list(type = "driving"),
              range = list(enabled = TRUE, width = 3600))

union <- make_union_intersect(id = "union of driving to and from Trafalgar Square",
                               search_ids = list('driving from Trafalgar Square',
                                                 'driving to Trafalgar Square'))
intersection <- make_union_intersect(id = "intersection of driving to and from Trafalgar Square",
                               search_ids = list('driving from Trafalgar Square',
                                                 'driving to Trafalgar Square'))
result <-
  distance_map(
    departure_searches = departure_search,
    arrival_searches = arrival_search,
    unions = union,
    intersections = intersection
  )
}
}
