% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimulateTrawl.R
\name{sim_UnivariateTrawl}
\alias{sim_UnivariateTrawl}
\title{Simulates a univariate trawl process}
\usage{
sim_UnivariateTrawl(t, Delta = 1, burnin = 10,
  marginal = base::c("Poi", "NegBin"), trawl = base::c("Exp", "DExp",
  "supIG", "LM"), v = 0, m = 0, theta = 0, lambda1 = 0,
  lambda2 = 0, w = 0, delta = 0, gamma = 0, alpha = 0, H = 0)
}
\arguments{
\item{t}{parameter which specifying the length of the time interval
\eqn{[0,t]} for which a simulation of the trawl process is required.}

\item{Delta}{parameter \eqn{\Delta} specifying the length of the time step,
the default is 1}

\item{burnin}{parameter specifying the length of the burn-in period at the
beginning of the simulation}

\item{marginal}{parameter specifying the marginal distribution of the trawl}

\item{trawl}{parameter specifying the type of trawl function}

\item{v}{parameter of the Poisson distribution}

\item{m}{parameter of the negative binomial distribution}

\item{theta}{parameter \eqn{\theta} of the negative binomial distribution}

\item{lambda1}{parameter \eqn{\lambda_1} of the exponential (or
double-exponential) trawl function}

\item{lambda2}{parameter \eqn{\lambda_2} of the double-exponential trawl
function}

\item{w}{parameter of the double-exponential trawl function}

\item{delta}{parameter \eqn{\delta} of the supIG trawl function}

\item{gamma}{parameter \eqn{\gamma} of the supIG trawl function}

\item{alpha}{parameter \eqn{\alpha} of the long memory trawl function}

\item{H}{parameter of the long memory trawl function}
}
\description{
Simulates a univariate trawl process
}
\details{
This function simulates a univariate trawl process with either
 Poisson or negative binomial marginal law. For the trawl function there are
 currently four choices: exponential, double-exponential, supIG or long
 memory. More details on the precise simulation algorithm is available in the
 vignette.
}
\examples{
set.seed(1)
t <- 100
Delta <- 1
v <- 250
lambda <- 0.25
#Simulate a univariate trawl process with exponential trawl function and
#Poisson marginal law
trawl <- sim_UnivariateTrawl(t,Delta,burnin=50,marginal =c("Poi"),trawl
="Exp",v=v, lambda1=lambda)
#Plot the sample path of the simulated process
plot(trawl,type="p")
}
