\name{logBiomass}
\alias{logBiomass}
\title{Estimates the wood biomass of logs and truncated branches}
\usage{
  logBiomass(x, lowerD, higherD, logLength, density)
}
\arguments{
  \item{x}{the data frame holding the measures needed to
  perform the estimation}

  \item{lowerD}{The name of the data frame column holding
  diameter of the lower section in cm}

  \item{higherD}{The name of the data frame column holding
  the diameter of the higher section (usually smaller!) in
  cm}

  \item{logLength}{The name of the data frame column
  holding the length of the log or branch in m}

  \item{density}{The name of the data frame column holding
  the fresh density of the wood, defined as
  \eqn{D=\frac{V_f}{W_f}} where \eqn{V_f} is wood volume
  measured in the field (i.e. satured with water) in
  \eqn{m^3} and \eqn{W_f} is wood fresh weight in kg. Fresh
  density is measured in \eqn{\frac{kg}{m^3}}}
}
\description{
  Estimates the wood biomass of logs and truncated branches
  by computing their volume (using Smalian's formula) and
  converting it to fresh weight using wood fresh density.

  Smalian's formula: \eqn{V=\frac{Sb+Sd}{2}l} where \eqn{V}
  is the log volume, \eqn{Sb} is the aerea of the basal
  (lower) section, \eqn{Sd} is the area of the higher
  section and \eqn{l} is the length of the log.
}
\note{
  Diameters used to compute section areas should be
  measured under the bark layer! When this is not the case
  (scarcely ever!) and diameters include bark thickness the
  log biomass is somewhat over-estimated!
}
\references{
  la Marca, O. \emph{Elementi di dendrometria} 2004, Patron
  Editore (Bologna), p. 119
}
\seealso{
  Other Biomass: \code{\link{allometryABDC}},
  \code{\link{allometryAsca2011}},
  \code{\link{allometryCutini2009}},
  \code{\link{allometryPorte2002}},
  \code{\link{powerEquation}},
  \code{\link{pureQuadraticEquation}},
  \code{\link{treeBiomass}}, \code{\link{treeTotalBiomass}}
}

