% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc-methods.R
\name{calcDstTrp}
\alias{calcDstTrp}
\title{Calculate the triplet distance between two trees}
\usage{
calcDstTrp(tree_1, tree_2, nrmlsd = FALSE, parallel = FALSE,
  progress = "none")
}
\arguments{
\item{tree_1}{\code{TreeMan} object}

\item{tree_2}{\code{TreeMan} object}

\item{nrmlsd}{Boolean, should returned value be between 0 and 1? Default, FALSE.}

\item{parallel}{logical, make parallel?}

\item{progress}{name of the progress bar to use, see \code{\link{create_progress_bar}}}
}
\description{
Returns the triplet distance between two trees.
}
\details{
The triplet distance is calculated as the sum of different outgroups among
every triplet of tips between the two trees. Normalisation is performed by dividing
the resulting number by the total number of triplets shared between the two trees.
The triplet distance is calculated only for shared tips between the two trees. Parallelizable.
}
\examples{
library(treeman)
tree_1 <- randTree(10)
tree_2 <- randTree(10)
calcDstTrp(tree_1, tree_2)
}
\references{
Critchlow DE, Pearl DK, Qian C. (1996) The Triples Distance for rooted bifurcating phylogenetic trees.
Systematic Biology, 45, 323-34.
}
\seealso{
\code{\link{calcDstBLD}}, \code{\link{calcDstRF}} 
\url{https://github.com/DomBennett/treeman/wiki/calc-methods}
}
