tmPlot <-
function(dtf, 
	index, 
	vSize, 
	vColor="", 
	sortID="",
	type="auto",
	titles=NA,
	subtitles=NA,
	saveTm=FALSE) {
	#############
	## Process variable names and titles
	#############
	## First checks
	if (!exists("dtf")) stop("Dataframe <dtf> not defined")
	if (!exists("index")) stop("Attribute <index> not defined")
	if (!exists("vSize")) stop("Attribute <vSize> not defined")
	if (class(dtf)!="data.frame") stop("Object <dtf> is not a data.frame")
	if (any(!index %in% names(dtf))) stop("<index> is not a column name of <dtf>")


	#############
	## Internal functions
	#############
	formatTitle <- function(x) {

			isnumeric <- function(s) !is.na(as.numeric(s))
			
			s <- strsplit(x, " ")[[1]]
			string <- paste(toupper(substring(s, 1,1)), substring(s, 2),
			  sep="", collapse=" ")

			if (isnumeric(substring(string,nchar(string)-1,nchar(string)))&&
			!isnumeric(substring(string,nchar(string)-2,nchar(string)))) {
			string <- paste(substring(string,1,nchar(string)-2)," '",substring(string,nchar(string)-1,nchar(string)),sep="")
		} else if (isnumeric(substring(string,nchar(string)-3,nchar(string)))&&
			!isnumeric(substring(string,nchar(string)-4,nchar(string)))) {
			string <- paste(substring(string,1,nchar(string)-4),substring(string,nchar(string)-3,nchar(string)),sep=" ")
		}
		string	
	}
	
	formatColorTitle <- function(sx,x,sdiv,div) {
		string <- formatTitle(x)
		if (sx!=1) {	
			string<-paste(sx,string,sep=" ")
		}
		if (!is.na(div)) {
			stringDiv <- formatTitle(div)
			if (sdiv!=1) {
				stringDiv<-paste(sdiv,stringDiv,sep=" ")
			}
			string<-paste(string,"per",stringDiv,sep=" ")
		}
		string
	}
	
	vColorDivSplit <- function(vColor) {
		vColorDiv <- unlist(strsplit(vColor, split="/", fixed=TRUE))
		return (vColorDiv)
	}
	
	vColorMplySplit <- function(vColor) {
		vColorMply <- unlist(strsplit(vColor, split="*", fixed=TRUE))
		if (length(vColorMply)==1) {
			vColorMply <- c(1,vColorMply)
		}
		return (vColorMply)
	}


	
	## Get size variable(s)
	vSizeVector <- unlist(strsplit(vSize, split="+", fixed=TRUE))
	n <- length(vSizeVector)

	## Checks if all vSizes are valid
	for (i in 1:n) {
		if (!vSizeVector[i] %in% names(dtf)) stop(paste(vSizeVector[i]," is not a column in <dtf>", sep=""))
		if (class(dtf[,vSizeVector[i]])!="numeric" && class(dtf[,vSizeVector[i]])!="integer") stop(paste("Column ", vSizeVector[i], " is not numeric or integer",sep=""))
		if (any(is.na(dtf[,vSizeVector[i]]))) stop(paste("Column ", vSizeVector[i], " contains missing values.",sep=""))
		if (min(dtf[,vSizeVector[i]])<0) stop(paste("Column ", vSizeVector[i], " contains negative values.",sep=""))
	}

	## Checks if titles and subtitles have length n
	if (!is.na(titles[1]) && length(titles) != n) {warning(paste("Number of titles should be ", n, ". Titles will be ignored.", sep="")); titles <- NA}
	if (!is.na(subtitles[1]) && length(subtitles) != n) {warning(paste("Number of subtitles should be ", n, ". Subtitles will be ignored.", sep="")); titles <- NA}
		
	## Determine titles
	if (is.na(titles[1])) {	
		options(warn=-1) 
		vSizeNames <- mapply(FUN="formatTitle", vSizeVector)
		options(warn=0) 
	} else {
		vSizeNames <- as.character(titles)
	}

	## Process formula for color variables
	vColorAdd <- unlist(strsplit(vColor, split="+", fixed=TRUE))
	vColorDiv <- unlist(mapply(FUN="vColorDivSplit", vColorAdd))
			
	if (vColor=="") {
		vColorVector <- matrix(data=NA,nrow=2,ncol=n)
		vColorVectorBy <- matrix(data=NA,nrow=2,ncol=n)
	} else if (is.vector(vColorDiv)) {
		vColorVector <- unlist(mapply(FUN="vColorMplySplit", vColorDiv))
		vColorVectorBy <- matrix(data=NA,nrow=2,ncol=n)
	} else {
		vColorVector <- unlist(mapply(FUN="vColorMplySplit", vColorDiv[1,]))
		if (is.matrix(vColorVector)) {
			vColorVectorBy <- unlist(mapply(FUN="vColorMplySplit", vColorDiv[2,]))
		}
	}

	## Determine subtitles
	if (is.na(subtitles)) {	
		options(warn=-1) 
		if (!all(is.na(vColorVector))) {
			vColorNames <- mapply(FUN="formatColorTitle", vColorVector[1,],vColorVector[2,],vColorVectorBy[1,],vColorVectorBy[2,])
		} else vColorNames <- rep("",n)
		options(warn=0) 
	} else {
		vColorNames <- as.character(subtitles)
	}
		

	
	##########
	## Determine grid
	##########
	
	width <- par("din")[1]
	height <- par("din")[2]
	
	mx <- n
	numbers <- matrix(rep(1:mx, mx) * rep(1:mx, each=mx), nrow=mx,ncol=mx) 
	optnum <- rep(0,mx)
	
	for (i in 1:mx) {
		optnum[i] <- min(100,which(numbers[i,]>=n))
	}
	optnum <- unique(optnum)
	optnum <- optnum[optnum!=100]
	optn <- length(optnum)
	minAsp <- 0
	for (i in 1:optn){
		rW <- optnum[i]/width
		cH <- optnum[optn+1-i]/height
		aspR <- min(rW/cH, cH/rW)
		if (aspR > minAsp) {
			minAsp <- aspR
			minAspI <- i
		}
	}

	nCol <- optnum[minAspI]
	nRow <- optnum[optn+1-minAspI]
	

	############
	## Determine sorting order
	############
	ascending <- TRUE
	if (substr(sortID,1,1)=="-") {
		ascending <- FALSE
		sortID <- substr(sortID,2,nchar(sortID))
	}

	############
	## Determine treemap type
	############
	
	legenda <- TRUE
	if (type=="auto") {
		if (all(is.na(vColorVector))) {
			type <- "linked"
			legenda <- FALSE
		} else if (!all(is.na(vColorVectorBy))) {
			type <- "dens"
		} else {
			perc <- ((dtf[vSizeVector] - dtf[vColorVector[2,]] )/dtf[vColorVector[2,]])*100
			isNaN <- apply(perc, 2, FUN=is.nan)
			perc[isNaN] <- 0
			
			if (min(perc)<=-60|| max(perc)>=150) {
				if (min(dtf[vSizeVector])>=0 && max(dtf[vSizeVector])<=100) {
					type <- "perc"	
				} else type <- "dens"
			} else type <- "comp"
		}
	} else if (type=="linked") {
		legenda <- FALSE
	}
	
	
	###########
	## Agggregate data
	###########
	
	# varNames <- as.character(na.omit(unique(c(vSizeVector, vColorVector[2,]))))
	

	# dtf <- ddply(dtf, index, colwise(sum, varNames))
	
	
	
	
	# if (is.na(subindex)) {
		# varNames <- as.character(na.omit(unique(c(vSizeVector, vColorVector[2,]))))

		# dtf <-aggregate(x=dtf[varNames], by=list(dtf[,index]), FUN="sum", na.rm = TRUE)
		# names(dtf) <- c(index, names(dtf)[-1])
		# tempSubindices <- NA 
	# } else tempSubindices <- dtf[subindex]

	
	############
	## Plot treemap(s)
	############

	
	pushViewport(viewport(name="grid",layout=grid.layout(nRow, nCol)))


	iCol<-1
	iRow<-1
	tm<-list()
	for (i in 1:n) {
		datSize<-as.numeric(dtf[[vSizeVector[i]]])
		if (all(is.na(vColorVector))) { 
			datColor<-dtf[[vSizeVector[1]]]
		} else {
			datColor<-dtf[[vColorVector[2,i]]]/as.numeric(vColorVector[1,i])
			if (!is.na(vColorVectorBy[i])) {
				datColor<-datColor/(dtf[[vColorVectorBy[2,i]]]/as.numeric(vColorVectorBy[1,i]))
			}
		}
		pushViewport(viewport(name=paste("tm",i,sep=""),layout.pos.col=iCol, layout.pos.row=iRow))
#		grid.rect(gp=gpar(col="red"))
		if (sortID=="size") {
			sortDat <- datSize
		} else if (sortID=="color") {
			sortDat <- datColor
		} else if (sortID=="") {
			sortDat <- datSize #NA
		} else {
			sortDat <- dtf[sortID]
		}
		if (!ascending) {
			sortDat <- -sortDat
		}
		dat<-data.frame(value=datSize, value2=datColor, sortInd=sortDat)
		names(dat) <- c("value", "value2", "sortInd")
		for (j in 1:length(index)) {
			indName <- paste("index", j, sep="")
			dat[[indName]] <- dtf[[index[j]]]
		}		

		tm[[i]] <- baseTreemap(
			dat=dat,
			type=type,
			legenda=legenda,
			sizeTitle=vSizeNames[i],
			colorTitle=vColorNames[i])
			
		upViewport()
		iRow<-iRow+1
		if (iRow>nRow) {
			iRow<-1
			iCol<-iCol+1
		}	
	}
	
	# go to root viewport (from grid layout)
	upViewport()

	# save treemaps (indices, subindices, and coordinates), and number of rows and number of columns)
	if (saveTm) {
		tmSave <- list()
		tmSave$tm <- tm
		tmSave$nRow <- nRow
		tmSave$nCol <- nCol
		return(tmSave)
	} else{
		return()
	}
}

