% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distFunctions.R
\name{polyToDistMat}
\alias{polyToDistMat}
\title{Calculates the distance matrix from a list coefficient matrices}
\usage{
polyToDistMat(
  coefficientMatrices,
  method = c("logDiff", "wLogDiff", "pa", "ap"),
  numThreads = -1
)
}
\arguments{
\item{coefficientMatrices}{list of coefficient matrices}

\item{method}{method to use when calculating coefficient distances:
\describe{
  \item{\dQuote{logDiff}}{for two coefficient matrices A and B returns sum(log(1+abs(A-B))}
  \item{\dQuote{wLogDiff}}{performs the \dQuote{logDiff} method with weights on the rows}
  \item{\dQuote{pa}}{total pairs where the coefficient is present in one matrix and absent in the other (presence-absence)}
  \item{\dQuote{ap}}{opposite comparison of pa (absence-presence)}
}}

\item{numThreads}{number of threads to be used, the default (-1) will use the number of cores in the machine and numThreads = 0 will only use the main thread}
}
\value{
distance matrix calculated from argument coefficient matrices
}
\description{
Calculates the distance matrix from a list coefficient matrices
}
\note{
\itemize{
  \item the substituted y coefficient vector and the complex tip label coefficient matrix only support the \dQuote{logDiff} method
  \item \dQuote{pa} and \dQuote{ap} force symmetry in the output distance matrix
}
}
\examples{

library(treenomial)
library(ape)

# coefficient matrices for ten trees of 20 tips
coeffs <- treeToPoly(rmtree(10, 20), numThreads = 0)

# distance matrix from the list of coefficient matrices
d <- polyToDistMat(coeffs, method = "logDiff", numThreads = 0)

# using the absence-presence method
d <- polyToDistMat(coeffs, method = "ap", numThreads = 0)
}
