% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parser.R
\name{parser}
\alias{parser}
\title{Create a new parser}
\usage{
parser(language)
}
\arguments{
\item{language}{\verb{[tree_sitter_language]}

A language object.}
}
\value{
A new parser.
}
\description{
\code{parser()} constructs a parser from a tree-sitter \code{language} object. You can
use \code{\link[=parser_parse]{parser_parse()}} to parse language specific text with it.
}
\examples{
\dontshow{if (rlang::is_installed("treesitter.r")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
language <- treesitter.r::language()
parser <- parser(language)
parser

text <- "1 + foo"
tree <- parser_parse(parser, text)
tree
\dontshow{\}) # examplesIf}
}
