% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trekcolors.R
\name{trek_pal}
\alias{trek_pal}
\alias{view_trek_pals}
\title{Star Trek color palettes}
\usage{
trek_pal(palette, reverse = FALSE)

view_trek_pals(palette)
}
\arguments{
\item{palette}{character, name of predefined palette. If missing, return all available palette names.}

\item{reverse}{logical, reverse color order.}
}
\value{
character vector of hex colors or palette names
}
\description{
Return a predefined Star Trek color palette from the \code{trekpals} dataset.
}
\details{
Many of the palettes are qualitative, and not necessarily evenly spaced in terms of hue, saturation or brightness.
This is because many palettes come from logos, symbols, insignia and other simple representations.
However, several palettes have specifically been constructed as sequential or divergent if it made sense to do so based on the dominant colors present.
Additional special functions exist for the subset of LCARS palettes.
}
\examples{
trek_pal("lcars_2357")
# leave palette blank to list available names:
trek_pal()

# to view all palettes
view_trek_pals()
}
\seealso{
\code{\link{lcars_pals}}, \code{\link{scale_lcars}}
}
