% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognostics.R
\name{cog}
\alias{cog}
\title{Create a Cognostics Object}
\usage{
cog(val = NULL, desc = "", group = "common", type = NULL,
  defLabel = FALSE, defActive = TRUE, filterable = TRUE,
  sortable = TRUE, log = NULL)
}
\arguments{
\item{val}{a scalar value (numeric, characer, date, etc.)}

\item{desc}{a description for this cognostic value}

\item{group}{optional categorization of the cognostic for organizational purposes}

\item{type}{the desired type of cognostic you would like to compute (see details)}

\item{defLabel}{should this cognostic be used as a panel label in the viewer by default?}

\item{defActive}{should this cognostic be active (available for sort / filter / sample) by default?}

\item{filterable}{should this cognostic be filterable?  Default is \code{TRUE}.  It can be useful to set this to \code{FALSE} if the cognostic is categorical with many unique values and is only desired to be used as a panel label.}

\item{sortable}{should this cognostic be sortable?}

\item{log}{when being used in the viewer for visual univariate and bivariate filters, should the log be computed?  Useful when the distribution of the cognostic is very long-tailed or has large outliers.  Can either be a logical or a positive integer indicating the base.}
}
\value{
object of class "cog"
}
\description{
Create a cognostics object.  To be used inside of the function passed to the \code{cogFn} argument of \code{\link{makeDisplay}} for each cognostics value to be computed for each subset.
}
\details{
Different types of cognostics can be specified through the \code{type} argument that will affect how the user is able to interact with those cognostics in the viewer.  This can usually be ignored because it will be inferred from the implicit data type of \code{val}.  But there are special types of cognostics, such as geographic coordinates and relations (not implemented) that can be specified as well.  Current possibilities for \code{type} are "key", "integer", "numeric", "factor", "date", "time", "geo", "rel", "hier", "href".
}
\examples{
d <- stack(data.frame(EuStockMarkets))
d$time <- rep(as.numeric(time(EuStockMarkets)), 4)
d$year <- floor(d$time)

byIndexYear <- divide(d, by = c("ind", "year"))

cogFn <- function(x)
  list(lormse = cogLoessRMSE(values ~ time, data = x, span = 0.3, degree = 2),
       slope  = cogSlope(values ~ time, data = x),
       range  = cogRange(x$values),
       mean   = cogMean(x$values),
       max    = cog(max(x$values, na.rm = TRUE), desc = "max value"))

applyCogFn(cogFn, byIndexYear[[1]])

library(lattice)
panelFn <- function(x)
  xyplot(values ~ time, data = x,
    panel = function(x, y, ...) {
      panel.xyplot(x, y, ...)
      panel.loess(x, y, span = 0.3,
        degree = 2, evaluation = 200, col = "black")
    })

vdbConn(tempfile(), autoYes = TRUE)
makeDisplay(byIndexYear, name = "ts_index_year",
  cogFn = cogFn, panelFn = panelFn)

\dontrun{
# sort and fiter the index/year panels by slope and loess RMSE
view(name = "ts_index_year")
}
}
\seealso{
\code{\link{makeDisplay}}, \code{\link{cogRange}}, \code{\link{cogMean}}, \code{\link{cogScagnostics}}, \code{\link{cogLoessRMSE}}
}
