% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/state.R
\name{validateState}
\alias{validateState}
\title{Validate State Parameters}
\usage{
validateState(x, displayObj = NULL, checkDisplay = TRUE)
}
\arguments{
\item{x}{a list of state parameter settings (such as layout, sorting, filtering, etc.) to use when the display is viewed (see details)}

\item{displayObj}{a display object to validate against (if not provided and checkDisplay is TRUE, it will be fetched based on \code{x})}

\item{checkDisplay}{should the state be checked against a display (to make sure fields match, etc.) or should it simply be checked for structure?}
}
\value{
a modified state parameter list that is valid, an object of class "cogState"
}
\description{
Validate state parameters for a Trelliscope display
}
\note{
See \code{\link{stateSpec}} for details on how to specify state.
}
\examples{
state <- stateSpec(
  name = "my_display",
  sort = list(state = "desc", county = "asc"),
  filter = list(
    county = list(regex = "Ben"),
    state = list(select = c("OR", "WA")),
    meanList = list(from = 50, to = 150)
  ),
  layout = list(nrow = 2, ncol = 4),
  labels = c("county", "state")
)

state <- validateState(state, checkDisplay = FALSE)

makeStateHash(state)
}
\seealso{
\code{\link{view}}, \code{\link{cogDisplayHref}}
}
