% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy.R
\name{map_cog}
\alias{map_cog}
\title{Apply a function to each element of a vector and return a vector of cognostics data frames}
\usage{
map_cog(.x, .f, ...)
}
\arguments{
\item{.x}{a list or atomic vector (see \code{\link[purrr]{map}} for details)}

\item{.f}{a function, formula, or atomic vector (see \code{\link[purrr]{map}} for details)}

\item{...}{additional arguments passed on to .f (see \code{\link[purrr]{map}} for details)}
}
\description{
Apply a function to each element of a vector and return a vector of cognostics data frames
}
\details{
See \code{\link[purrr]{map}}
}
\examples{
\donttest{
library(dplyr)
library(tidyr)
library(rbokeh)
ggplot2::mpg \%>\%
  group_by(manufacturer, class) \%>\%
  nest() \%>\%
  mutate(panel = map_plot(data,
    ~ figure(xlab = "City mpg", ylab = "Highway mpg") \%>\%
        ly_points(cty, hwy, data = .x))) \%>\%
  trelliscope(name = "city_vs_highway_mpg")
}
}
