% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy.R
\name{map_plot}
\alias{map_plot}
\title{Apply a function to each element of a vector and return a vector of plots}
\usage{
map_plot(.x, .f, ...)
}
\arguments{
\item{.x}{a list or atomic vector (see \code{\link[purrr]{map}} for details)}

\item{.f}{a function, formula, or atomic vector (see \code{\link[purrr]{map}} for details)}

\item{...}{additional arguments passed on to .f (see \code{\link[purrr]{map}} for details)}
}
\description{
Apply a function to each element of a vector and return a vector of plots
}
\details{
See \code{\link[purrr]{map}}
}
\examples{
\donttest{
library(dplyr)
library(tidyr)
library(purrr)
library(plotly)
library(gapminder)

# nest gapminder data by country
by_country <- gapminder \%>\%
  nest(data = !one_of(c("country", "continent")))

# add in a plot column with map_plot
by_country <- by_country \%>\% mutate(
  panel = map_plot(data, function(x) {
    plot_ly(data = x, x = ~year, y = ~lifeExp,
      type = "scatter", mode = "markers") \%>\%
      layout(
        xaxis = list(range = c(1948, 2011)),
        yaxis = list(range = c(10, 95)))
  }))

# plot it
by_country \%>\%
  trelliscope("gapminder", nrow = 2, ncol = 7, width = 300)

# example using mpg data
ggplot2::mpg \%>\%
  nest(data = !one_of(c("manufacturer", "class"))) \%>\%
  mutate(panel = map_plot(data, function(x) {
    plot_ly(data = x, x = ~hwy, y = ~cty,
      type = "scatter", mode = "markers")
  })) \%>\%
  trelliscope(name = "city_vs_highway_mpg")
}
}
